from django.utils import timezone, dateformat
import locale

# 本日の日付（yyyy-mm-dd）を取得します。
def get_today(*args, **kwargs):
    return dateformat.format(timezone.now(), 'Y-m-d')

# 現在の日時（yyyy-mm-dd hh:mm;dd）を取得します。
def get_timezone_now(self, *args, **kwargs):
    return timezone.now()

# ログインユーザのユーザ名を取得します。
def get_user_id(self, *args, **kwargs):
    return self.request.user.username

# 項目を非活性状態にします。
def is_disabled(self, **kwargs):
    return True

# 検索結果の表示項目をフォーマットします。
# カンマ区切り表示
def manipulate_comma(value):
    # 値が None 以外の場合のみ、フォーマットを適用する
    if value is None:
        return None
    else:
        return '{:,}'.format(value)

# 円表示（カンマ区切り）
def manipulate_yen(value):
    # 値が None 以外の場合のみ、フォーマットを適用する
    if value is None:
        return None
    else:
        return '\{:,}'.format(value)

# 人数表示（カンマ区切り）
def manipulate_people(value):
    # 値が None 以外の場合のみ、フォーマットを適用する
    if value is None:
        return None
    else:
        return '{:,}人'.format(value)

# 時間を漢字表示
def manipulate_date(value):
    # 値が None 以外の場合のみ、フォーマットを適用する
    if value is None:
        return None
    else:
        locale.setlocale(locale.LC_ALL, '')
        return value.strftime("%Y{0}%m{1}%d{2} (%a)").format(*'年月日')