from django.shortcuts import redirect, render
from django.urls import resolve, reverse
from ultra.models import *
import openpyxl
from openpyxl.writer.excel import save_virtual_workbook

def daily_report_output(self, request, response, *args, **kwargs):
    """ビューの事後処理"""
    if request.method == 'GET':
        # ReportView の get() 処理の内容をコピペしたもの
        pks = request.GET.getlist('pk')
        limit = 35
        if len(pks) > limit:
            messages.error(self.request, '帳票に出力できる項目数は最大で' + str(limit) + '件です。')
            return redirect(app_name + ':sagyou_shiji_sho_chouhyou')
        objs = self.model.objects.filter(pk__in=pks)

        form = self.form_class(request.POST)
        if form.is_valid():
            try:
                file = UploadFile.objects.get(name=self.report_template_name)
            except UploadFile.DoesNotExist:
                messages.error(self.request, '帳票の雛形「' + self.report_template_name + '」が見つかりませんでした。')
                return redirect(app_name + ':sagyou_shiji_sho_chouhyou')
            wb = openpyxl.load_workbook(file.file.path)
            ws = wb.active
            row = 2
            for obj in objs:
                if obj.shozoku_busho_kodo.busho_mei:
                    ws.cell(row=row, column=openpyxl.utils.column_index_from_string('V')).value = str(obj.shozoku_busho_kodo.busho_mei)
                if obj.gyoumu_bunrui_kodo.gyoumu_mei:
                    ws.cell(row=row, column=openpyxl.utils.column_index_from_string('W')).value = str(obj.gyoumu_bunrui_kodo.gyoumu_mei)
                if obj.anken_kodo.anken_mei:
                    ws.cell(row=row, column=openpyxl.utils.column_index_from_string('X')).value = str(obj.anken_kodo.anken_mei)
                if obj.houkoku_sha_kodo.shain_mei:
                    ws.cell(row=row, column=openpyxl.utils.column_index_from_string('Y')).value = str(obj.houkoku_sha_kodo.shain_mei)
                if obj.houkoku_bi:
                    ws.cell(row=row, column=openpyxl.utils.column_index_from_string('Z')).value = (obj.houkoku_bi)
                if obj.houkoku_naiyou:
                    ws.cell(row=row, column=openpyxl.utils.column_index_from_string('AA')).value = str(obj.houkoku_naiyou)
                row += 1
            return self._export(wb)
        else:
            messages.error(self.request, '入力値が不正です。')
            return redirect(app_name + ':sagyou_shiji_sho_chouhyou')